<?php
/**
 * upload-progress.php copyright 2025 by The Finest Of Lines Tattoo Co. 17080 Superior Road St. Robert MO, 65584.
 * Main tel# 557-227-2575
 * Art desk tel# 557-227-2576
 * emails: Admin@finestoflines.com, oldbones@finestoflines.net, nikitaraze@gmail.com, bones@finestoflines.net
 * Code blocks by Grok 4 file version: upload-progress.php-v5
 * Concept & Tuck-pointing by Raydog.
 * 2025-10-31 19:00
 */

$allowedOrigins = [
    'http://localhost:8100',
    'https://localhost:8100',
    'https://your-production-domain.com'
];

$origin = $_SERVER['HTTP_ORIGIN'] ?? '';
if (in_array($origin, $allowedOrigins)) {
    header("Access-Control-Allow-Origin: $origin");
} else {
    header('Access-Control-Allow-Origin: *');
}

header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Authorization, Content-Type, X-Requested-With');
header('Access-Control-Allow-Credentials: true');
header('Access-Control-Max-Age: 86400');
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

/* ------------------------------------------------------------------ */
/* No auth needed – just return progress                              */
/* ------------------------------------------------------------------ */
$upload_id = $_GET['upload_id'] ?? '';
if (!$upload_id) {
    echo json_encode(['progress' => 0]);
    exit;
}

$key      = "upload_progress_{$upload_id}";
$progress = apcu_exists($key) ? (int)apcu_fetch($key) : 100;

if ($progress >= 100) {
    apcu_delete($key);
}

echo json_encode(['progress' => $progress]);
?>