<?php
session_start();

// Handle reset
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['reset'])) {
    session_destroy();
    $_SESSION = [];
    header('Location: ' . $_SERVER['PHP_SELF']);
    exit;
}

// Initialize step, tokens, and lineup_id if not set
if (!isset($_SESSION['step'])) {
    $_SESSION['step'] = 0;
    $_SESSION['jwt_token'] = '';
    $_SESSION['refresh_token'] = '';
    $_SESSION['lineup_id'] = null;
}

// Define curl commands
$commands = [
    [
        'name' => 'Login to Citadel',
        'method' => 'POST',
        'url' => 'https://data.finestoflines.net/citadel_2025/login',
        'headers' => ['Content-Type: application/json'],
        'data' => '{"email":"oldbones@finestoflines.net","password":"001"}'
    ],
    [
        'name' => 'List Lineup Records',
        'method' => 'GET',
        'url' => 'https://data.finestoflines.net/lineup_2025/records/lineup?filter[]=closed,eq,0&filter[]=hidden,eq,0',
        'headers' => function() { return ['X-API-Key: ' . $_SESSION['jwt_token']]; },
        'data' => null
    ],
    [
        'name' => 'Get Single Lineup Record',
        'method' => 'GET',
        'url' => function() { return 'https://data.finestoflines.net/lineup_2025/records/lineup/' . ($_SESSION['lineup_id'] ?: '1') . '?filter[]=closed,eq,0&filter[]=hidden,eq,0'; },
        'headers' => function() { return ['X-API-Key: ' . $_SESSION['jwt_token']]; },
        'data' => null
    ],
    [
        'name' => 'Create Lineup Record',
        'method' => 'POST',
        'url' => 'https://data.finestoflines.net/lineup_2025/records/lineup',
        'headers' => function() { return ['Content-Type: application/json', 'X-API-Key: ' . $_SESSION['jwt_token']]; },
        'data' => '{"t_artist_id":"1","patron_name":"John Doe","patron_phone":"123-456-7890","description":"Tattoo session","apptmnt_str":"Wed 10-Sep-25 @ 10:00 AM > 11:00 AM","duration_mins":"P0Y0M0DT1H0M0S","price":"150.00","evstart":"2025-09-10T10:00:00","evend":"2025-09-10T11:00:00","closed":"0","hidden":"0"}'
    ],
    [
        'name' => 'Update Lineup Record',
        'method' => 'PUT',
        'url' => function() { return 'https://data.finestoflines.net/lineup_2025/records/lineup/' . ($_SESSION['lineup_id'] ?: '1'); },
        'headers' => function() { return ['Content-Type: application/json', 'X-API-Key: ' . $_SESSION['jwt_token']]; },
        'data' => '{"description":"Updated tattoo session","price":"175.00","closed":"0","hidden":"0"}'
    ],
    [
        'name' => 'Delete Lineup Record',
        'method' => 'DELETE',
        'url' => function() { return 'https://data.finestoflines.net/lineup_2025/records/lineup/' . ($_SESSION['lineup_id'] ?: '1'); },
        'headers' => function() { return ['X-API-Key: ' . $_SESSION['jwt_token']]; },
        'data' => null
    ],
    [
        'name' => 'Test Profiles Access (Admin)',
        'method' => 'GET',
        'url' => 'https://data.finestoflines.net/lineup_2025/records/profiles',
        'headers' => function() { return ['X-API-Key: ' . $_SESSION['jwt_token']]; },
        'data' => null
    ]
];

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['next'])) {
    $_SESSION['step']++;
    if ($_SESSION['step'] >= count($commands)) {
        $_SESSION['step'] = 0; // Reset to start
    }
}

// Execute current command
$current_step = $_SESSION['step'];
$command = $commands[$current_step];
$method = $command['method'];
$url = is_callable($command['url']) ? $command['url']() : $command['url'];
$headers = is_callable($command['headers']) ? $command['headers']() : $command['headers'];
$data = is_callable($command['data']) ? $command['data']() : $command['data'];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
if ($headers) {
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
}
if ($data) {
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
}
$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// Parse response to update jwt_token or lineup_id
$response_data = json_decode($response, true);
if ($current_step === 0 && isset($response_data['token'])) {
    $_SESSION['jwt_token'] = $response_data['token'];
    $_SESSION['refresh_token'] = $response_data['refreshToken'];
} elseif ($current_step === 3 && isset($response_data['id'])) {
    $_SESSION['lineup_id'] = $response_data['id'];
}

// Format command for display
$command_display = "curl -X $method";
if ($headers) {
    foreach ($headers as $header) {
        $command_display .= " -H \"$header\"";
    }
}
if ($data) {
    $command_display .= " -d '$data'";
}
$command_display .= " $url";

?>
<!DOCTYPE html>
<html>
<head>
    <title>Lineup API Test Script</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        pre { background: #f4f4f4; padding: 10px; border: 1px solid #ddd; overflow-x: auto; }
        button { padding: 10px 20px; margin-right: 10px; background: #007bff; color: white; border: none; cursor: pointer; }
        button:hover { background: #0056b3; }
        .reset-button { background: #dc3545; }
        .reset-button:hover { background: #c82333; }
        h2 { margin-top: 20px; }
    </style>
    <script>
        function resetCookies() {
            document.cookie.split(";").forEach(function(c) {
                document.cookie = c.replace(/^ +/, "").replace(/=.*/, "=;expires=" + new Date().toUTCString() + ";path=/");
            });
        }
    </script>
</head>
<body>
    <h1>Lineup API Test Script</h1>
    <h2>Step <?php echo $current_step + 1; ?>: <?php echo $command['name']; ?></h2>
    <h3>Command:</h3>
    <pre><?php echo htmlspecialchars($command_display); ?></pre>
    <h3>Response (HTTP <?php echo $http_code; ?>):</h3>
    <pre><?php echo htmlspecialchars($response); ?></pre>
    <form method="post" style="display: inline;">
        <button type="submit" name="next">Next Command</button>
    </form>
    <form method="post" style="display: inline;" onsubmit="resetCookies()">
        <button type="submit" name="reset" class="reset-button">Reset</button>
    </form>
</body>
</html>